﻿using System;
using PostitCore;
using PostitCommon;
using System.Collections.Generic;
using Newtonsoft.Json;
using System.Net.Http;

namespace DeXGets
{
    public class LearnerPersonals : BaseClass
    {
        public class LearnerPersonals_Response
        {
            public Guid ExternalID;
            public Nullable<DateTime> DateOfBirth;
            public string LegalSurame;
            public string LegalForename;
            public Nullable<DateTime> DateOfDeath;
        }
        /// <summary>
        /// Returns the set of contact contact basics
        /// </summary>
        /// <param name="token"></param>
        /// <param name="key"></param>
        /// <param name="httpClient"></param>
        /// <returns></returns>
        public Dictionary<Guid, LearnerPersonals_Response> GetValues(string token, string key, HttpClient httpClient)
        {
            Dictionary<Guid, LearnerPersonals_Response> values = new Dictionary<Guid, LearnerPersonals_Response>();
            string URL_LearnerPersonal = SetURL("Learner", "LearnerPersonals?$select=ExternalID,DateOfBirth,LegalSurname,LegalForename,DateOfDeath");
            string resp = DoCall(URL_LearnerPersonal, token, httpClient, key);
            ODataResponse<LearnerPersonals_Response> learners = null;
            try
            {
                learners = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LearnerPersonals_Response>>(resp);
                foreach (LearnerPersonals_Response s in learners.Value)
                {
                    values.Add(s.ExternalID, s);
                }
                // Very likely > 1000
                while (!string.IsNullOrEmpty(learners.NextLink))
                {
                    resp = DoCall(GetNextLink(learners.NextLink), token, httpClient, key);
                    learners = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LearnerPersonals_Response>>(resp);
                    foreach (LearnerPersonals_Response s in learners.Value)
                    {
                        values.Add(s.ExternalID, s);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorMessage = "Error: " + resp;
            }
            return values;
        }
    }
}
